/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.events.ProspectEvent;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.network.PacketProspectResult;
import net.dries007.tfc.objects.items.metal.ItemMetalTool;
import net.dries007.tfc.util.skills.ProspectingSkill;
import net.dries007.tfc.util.skills.SkillType;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
public class ItemProspectorPick
extends ItemMetalTool {
    private static final int PROSPECT_RADIUS = 12;
    private static final int COOLDOWN = 10;
    private static final Random RANDOM = new Random();

    public ItemProspectorPick(Metal metal, Metal.ItemType type) {
        super(metal, type);
    }

    @Override
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, @Nullable EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing != null) {
            SoundType soundType = state.func_177230_c().getSoundType(state, worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundType.func_185846_f(), SoundCategory.BLOCKS, 1.0f, soundType.func_185847_b());
            if (!worldIn.field_72995_K) {
                ProspectEvent.Server event;
                float falseNegativeChance = 0.3f;
                ProspectingSkill skill = CapabilityPlayerData.getSkill(player, SkillType.PROSPECTING);
                if (skill != null) {
                    falseNegativeChance = 0.3f - 0.1f * (float)skill.getTier().ordinal();
                }
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                player.func_184811_cZ().func_185145_a((Item)this, 10);
                RANDOM.setSeed(pos.func_177958_n() * 92853 ^ pos.func_177956_o() * 1959302 ^ pos.func_177952_p() * 2839402);
                ItemStack targetStack = this.getOreStack(worldIn, pos, state, false);
                if (!targetStack.func_190926_b()) {
                    event = new ProspectEvent.Server(player, pos, ProspectResult.Type.FOUND, targetStack);
                    if (skill != null) {
                        skill.addSkill(pos);
                    }
                } else if (RANDOM.nextFloat() < falseNegativeChance) {
                    event = new ProspectEvent.Server(player, pos, ProspectResult.Type.NOTHING, null);
                } else {
                    Collection<ProspectResult> results = this.scanSurroundingBlocks(worldIn, pos);
                    if (results.isEmpty()) {
                        event = new ProspectEvent.Server(player, pos, ProspectResult.Type.NOTHING, null);
                    } else {
                        ProspectResult result = (ProspectResult)results.toArray()[RANDOM.nextInt(results.size())];
                        event = new ProspectEvent.Server(player, pos, result.getType(), result.ore);
                        if (ConfigTFC.General.DEBUG.enable) {
                            for (ProspectResult debugResult : results) {
                                TerraFirmaCraft.getLog().debug(debugResult.ore.func_82833_r() + ": " + String.format("%.02f", debugResult.score));
                            }
                        }
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)event);
                PacketProspectResult packet = new PacketProspectResult(event.getBlockPos(), event.getResultType(), event.getVein());
                TerraFirmaCraft.getNetwork().sendTo((IMessage)packet, (EntityPlayerMP)player);
            } else {
                this.addHitBlockParticle(worldIn, pos, facing, state);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    private Collection<ProspectResult> scanSurroundingBlocks(World world, BlockPos center) {
        HashMap<String, ProspectResult> results = new HashMap<String, ProspectResult>();
        for (BlockPos.MutableBlockPos pos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)center.func_177982_a(-12, -12, -12), (BlockPos)center.func_177982_a(12, 12, 12))) {
            ItemStack stack = this.getOreStack(world, (BlockPos)pos, world.func_180495_p((BlockPos)pos), true);
            if (stack.func_190926_b()) continue;
            String oreName = stack.func_82833_r();
            if (results.containsKey(oreName)) {
                ProspectResult prospectResult = (ProspectResult)results.get(oreName);
                prospectResult.score = prospectResult.score + 1.0;
                continue;
            }
            results.put(oreName, new ProspectResult(stack, 1.0));
        }
        return results.values();
    }

    @Nonnull
    private ItemStack getOreStack(World world, BlockPos pos, IBlockState state, boolean ignoreGrade) {
        for (VeinType vein : VeinRegistry.INSTANCE.getVeins().values()) {
            if (!vein.isOreBlock(state)) continue;
            Block block = state.func_177230_c();
            if (vein.getOre() != null && vein.getOre().isGraded() && !ignoreGrade) {
                ItemStack result = block.getPickBlock(state, null, world, pos, null);
                result.func_77964_b(Ore.Grade.NORMAL.getMeta());
                return result;
            }
            return block.getPickBlock(state, null, world, pos, null);
        }
        return ItemStack.field_190927_a;
    }

    private void addHitBlockParticle(World world, BlockPos pos, EnumFacing side, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
        for (int i = 0; i < 2; ++i) {
            double xOffset = (double)x + RANDOM.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
            double yOffset = (double)y + RANDOM.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
            double zOffset = (double)z + RANDOM.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
            switch (side) {
                case WEST: {
                    xOffset = (double)x + axisalignedbb.field_72340_a - 0.1;
                    break;
                }
                case EAST: {
                    xOffset = (double)x + axisalignedbb.field_72336_d + 0.1;
                    break;
                }
                case DOWN: {
                    yOffset = (double)y + axisalignedbb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    yOffset = (double)y + axisalignedbb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    zOffset = (double)z + axisalignedbb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    zOffset = (double)z + axisalignedbb.field_72334_f + 0.1;
                }
            }
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public static final class ProspectResult {
        private final ItemStack ore;
        private double score;

        ProspectResult(ItemStack itemStack, double num) {
            this.ore = itemStack;
            this.score = num;
        }

        public Type getType() {
            if (this.score < 10.0) {
                return Type.TRACES;
            }
            if (this.score < 20.0) {
                return Type.SMALL;
            }
            if (this.score < 40.0) {
                return Type.MEDIUM;
            }
            if (this.score < 80.0) {
                return Type.LARGE;
            }
            return Type.VERY_LARGE;
        }

        public static enum Type {
            VERY_LARGE("tfc.propick.found_very_large"),
            LARGE("tfc.propick.found_large"),
            MEDIUM("tfc.propick.found_medium"),
            SMALL("tfc.propick.found_small"),
            TRACES("tfc.propick.found_traces"),
            FOUND("tfc.propick.found"),
            NOTHING("tfc.propick.found_nothing");

            private static final Type[] VALUES;
            public final String translation;

            private Type(String translation) {
                this.translation = translation;
            }

            public static Type valueOf(int ordinal) {
                return VALUES[ordinal];
            }

            static {
                VALUES = Type.values();
            }
        }
    }
}

